/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.monitor;

import filenet.pa.admin.PAStatisticsSnapShot;
import filenet.pa.main.DTSStatisticsSnapShot;
import filenet.pa.publisher.PublisherStatisticsSnapShot;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.pa.PANode;
import filenet.vw.apps.taskman.pa.monitor.PAStatisticFormatter;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class PAMonitorPropertyPanel
extends VWTaskPropertyPanel {
    PAStatisticFormatter m_formatter = new PAStatisticFormatter();
    PANode m_paNode = null;
    Statistic m_numberOfPublishedEvents = null;
    Statistic m_avgNumberOfEventsPublishedPerSec = null;
    Statistic m_numberOfPEErroneousEvents = null;
    Statistic m_numberOfCEErroneousEvents = null;
    Statistic m_numberOfCEPublishedEvents = null;
    Statistic m_dimensionCacheHitRate = null;
    Statistic m_factTableCacheHitRate = null;
    Statistic m_avgDatabaseUpdateTime = null;
    Statistic m_avgDatabaseUpdatesPerInterval = null;
    Statistic m_avgCubeProcessingTime = null;
    Statistic m_avgPubIntervalCubeProcessingTime = null;

    public PAMonitorPropertyPanel(PANode paNode) throws Exception {
        this.m_paNode = paNode;
        this.initLayout();
    }

    public void actionPerformed(ActionEvent event) {
    }

    public void applyProperties() throws Exception {
    }

    public void resetProperties() throws Exception {
    }

    protected void updateStatistics(final PAStatisticsSnapShot stats) {
        Runnable doUpdateStatistics = new Runnable(){

            public void run() {
                PublisherStatisticsSnapShot pubStats = stats.getPublisherStats();
                DTSStatisticsSnapShot dtsStats = stats.getDTSStats();
                if (pubStats == null || dtsStats == null) {
                    PAMonitorPropertyPanel.this.clearStatistics();
                    return;
                }
                PAMonitorPropertyPanel.this.m_dimensionCacheHitRate.setPercentValue(pubStats.getDimensionCacheHitRate());
                PAMonitorPropertyPanel.this.m_factTableCacheHitRate.setPercentValue(pubStats.getFactCacheHitRate());
                PAMonitorPropertyPanel.this.m_numberOfPublishedEvents.setValue(pubStats.getPEEventsPublishedSinceReset());
                PAMonitorPropertyPanel.this.m_avgNumberOfEventsPublishedPerSec.setValue(pubStats.getAvgEventsPublishedPerSec());
                PAMonitorPropertyPanel.this.m_numberOfPEErroneousEvents.setValue(pubStats.getNumberOfPEQuarantinedEvents());
                PAMonitorPropertyPanel.this.m_numberOfPEErroneousEvents.setVisible(pubStats.getNumberOfPEQuarantinedEvents() > 0);
                PAMonitorPropertyPanel.this.m_numberOfCEErroneousEvents.setValue(pubStats.getNumberOfCEQuarantinedEvents());
                PAMonitorPropertyPanel.this.m_numberOfCEErroneousEvents.setVisible(pubStats.getNumberOfCEQuarantinedEvents() > 0);
                PAMonitorPropertyPanel.this.m_avgDatabaseUpdateTime.setValue(pubStats.getAvgDatabaseUpdateTimeInSec());
                PAMonitorPropertyPanel.this.m_avgDatabaseUpdatesPerInterval.setValue(pubStats.getAvgDatabaseUpdatesPerInterval());
                PAMonitorPropertyPanel.this.m_avgCubeProcessingTime.setValue(dtsStats.getAvgCubeProcessingTimeInSec());
                PAMonitorPropertyPanel.this.m_numberOfCEPublishedEvents.setValue(pubStats.getCEEventsPublishedSinceReset());
                PAMonitorPropertyPanel.this.m_avgPubIntervalCubeProcessingTime.setValue(dtsStats.getAvgWIPCubeProcessingTimeInSec());
            }
        };
        VWTaskUtil.performUIOperation(doUpdateStatistics, true);
    }

    protected void clearStatistics() {
        Runnable doClearStatistics = new Runnable(){

            public void run() {
                PAMonitorPropertyPanel.this.m_dimensionCacheHitRate.clear();
                PAMonitorPropertyPanel.this.m_factTableCacheHitRate.clear();
                PAMonitorPropertyPanel.this.m_numberOfPublishedEvents.clear();
                PAMonitorPropertyPanel.this.m_avgNumberOfEventsPublishedPerSec.clear();
                PAMonitorPropertyPanel.this.m_numberOfPEErroneousEvents.clear();
                PAMonitorPropertyPanel.this.m_numberOfPEErroneousEvents.setVisible(false);
                PAMonitorPropertyPanel.this.m_numberOfCEErroneousEvents.clear();
                PAMonitorPropertyPanel.this.m_numberOfCEErroneousEvents.setVisible(false);
                PAMonitorPropertyPanel.this.m_avgDatabaseUpdateTime.clear();
                PAMonitorPropertyPanel.this.m_avgDatabaseUpdatesPerInterval.clear();
                PAMonitorPropertyPanel.this.m_avgCubeProcessingTime.clear();
                PAMonitorPropertyPanel.this.m_numberOfCEPublishedEvents.clear();
                PAMonitorPropertyPanel.this.m_avgPubIntervalCubeProcessingTime.clear();
            }
        };
        VWTaskUtil.performUIOperation(doClearStatistics, true);
    }

    private void initLayout() {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.getStatisticsPanel(), 20, 31), "Center");
    }

    protected void refreshLayout() {
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private JPanel getStatisticsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        StatisticPanel statPanel = null;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 23;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, Integer.parseInt(VWResource.StatisticPanelRightMarginSize));
        statPanel = new StatisticPanel(VWResource.Cache);
        this.m_dimensionCacheHitRate = statPanel.addStatistic(VWResource.DimensionCacheHitRate);
        this.m_factTableCacheHitRate = statPanel.addStatistic(VWResource.FactTableCacheHitRate);
        ++c.gridy;
        panel.add((Component)statPanel, c);
        statPanel = new StatisticPanel(VWResource.DataPublishing);
        this.m_numberOfPublishedEvents = statPanel.addStatistic(VWResource.PEEventsPublishedCapital);
        this.m_numberOfCEPublishedEvents = statPanel.addStatistic(VWResource.CEEventsPublishedCapital);
        this.m_avgNumberOfEventsPublishedPerSec = statPanel.addStatistic(VWResource.AvgEventsPublishedPerSec);
        this.m_numberOfPEErroneousEvents = statPanel.addStatistic(VWResource.NumberOfPEErroneousEvents);
        this.m_numberOfPEErroneousEvents.setVisible(false);
        this.m_numberOfPEErroneousEvents.setColor(Color.red);
        this.m_numberOfCEErroneousEvents = statPanel.addStatistic(VWResource.NumberOfCEErroneousEvents);
        this.m_numberOfCEErroneousEvents.setVisible(false);
        this.m_numberOfCEErroneousEvents.setColor(Color.red);
        ++c.gridy;
        panel.add((Component)statPanel, c);
        statPanel = new StatisticPanel(VWResource.DatabaseOperations);
        this.m_avgDatabaseUpdateTime = statPanel.addStatistic(VWResource.AvgDatabaseUpdateTime);
        this.m_avgDatabaseUpdatesPerInterval = statPanel.addStatistic(VWResource.AvgDatabaseUpdatesPerInterval);
        this.m_avgCubeProcessingTime = statPanel.addStatistic(VWResource.AvgCubeProcessingTime);
        this.m_avgPubIntervalCubeProcessingTime = statPanel.addStatistic(VWResource.AvgPubIntervalCubeProcessingTime);
        ++c.gridy;
        panel.add((Component)statPanel, c);
        ++c.gridy;
        c.weighty = 1.0;
        panel.add(Box.createHorizontalStrut(0), c);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:39:38  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.11  $";
    }

    private class Statistic
    implements FocusListener {
        JTextField nameField = null;
        JTextField valueField = null;
        private Border m_textBorder = null;

        protected Statistic(String name) {
            this.nameField = new JTextField("  " + name);
            this.nameField.setFont(new JLabel().getFont());
            this.nameField.setEditable(false);
            this.nameField.addFocusListener(this);
            this.valueField = new JTextField(" --- ");
            this.valueField.setEditable(false);
            this.valueField.setColumns(10);
            this.valueField.setHorizontalAlignment(4);
            this.valueField.addFocusListener(this);
        }

        public void setVisible(boolean visible) {
            this.nameField.setVisible(visible);
            this.valueField.setVisible(visible);
        }

        public void setColor(Color color) {
            this.nameField.setForeground(color);
            this.valueField.setForeground(color);
        }

        public JTextField getNameField() {
            return this.nameField;
        }

        public JTextField getValueField() {
            return this.valueField;
        }

        public void setName(String name) {
            this.nameField.setText(name);
        }

        public void setValue(long value) {
            this.valueField.setText(PAMonitorPropertyPanel.this.m_formatter.formatLong(value));
        }

        public void setValue(float value) {
            this.valueField.setText(PAMonitorPropertyPanel.this.m_formatter.formatFloat(value));
        }

        protected void setPercentValue(float value) {
            this.valueField.setText(PAMonitorPropertyPanel.this.m_formatter.formatPercentage(value));
        }

        protected void clear() {
            this.valueField.setText(" --- ");
        }

        public void focusGained(FocusEvent e) {
            Object source = e.getSource();
            if (source instanceof JTextField && !((JTextField)source).isEditable() || source instanceof JTextArea && !((JTextArea)source).isEditable()) {
                this.m_textBorder = ((JComponent)source).getBorder();
                ((JComponent)source).setBorder(BorderFactory.createEtchedBorder());
            }
        }

        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source instanceof JTextField && !((JTextField)source).isEditable() || source instanceof JTextArea && !((JTextArea)source).isEditable()) {
                ((JComponent)source).setBorder(this.m_textBorder);
            }
        }
    }

    private class StatisticPanel
    extends VWToolbarBorder {
        GridBagConstraints c;

        public StatisticPanel(String title) {
            super(title, 0);
            this.c = new GridBagConstraints();
            this.getClientPanel().setLayout(new GridBagLayout());
            this.c.fill = 2;
        }

        public Statistic addStatistic(String name) {
            Statistic stat = new Statistic(name);
            this.c.weightx = 1.0;
            this.c.weighty = 0.0;
            this.c.insets = new Insets(0, 0, 0, 0);
            this.c.gridx = 0;
            ++this.c.gridy;
            this.c.anchor = 23;
            this.getClientPanel().add((Component)stat.getNameField(), this.c);
            this.c.weightx = 0.0;
            this.c.weighty = 0.0;
            this.c.insets = new Insets(0, 0, 0, 0);
            this.c.gridx = 1;
            this.c.anchor = 24;
            this.getClientPanel().add((Component)stat.getValueField(), this.c);
            return stat;
        }

        public void removeStatistic(Statistic stat) {
            this.getClientPanel().remove(stat.getNameField());
            this.getClientPanel().remove(stat.getValueField());
        }
    }
}

